import argparse
from pathlib import Path

from common import assert_file_correct


def parse_args():
    parser = argparse.ArgumentParser(description="Confirm that an ASDF file generated by generate_file.py can be read")
    parser.add_argument("filename", help="the filename to test")
    return parser.parse_args()


def main():
    args = parse_args()

    path = Path(args.filename)

    assert_file_correct(path)


if __name__ == "__main__":
    main()
