# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: rekor/v2/dsse.proto, rekor/v2/entry.proto, rekor/v2/hashedrekord.proto, rekor/v2/verifier.proto
# plugin: python-betterproto
# This file has been @generated

from typing import TYPE_CHECKING


if TYPE_CHECKING:
    from dataclasses import dataclass
else:
    from pydantic.dataclasses import dataclass

from typing import (
    List,
    Optional,
)

import betterproto
from pydantic import model_validator
from pydantic.dataclasses import rebuild_dataclass

from .....io import intoto as ____io_intoto__
from ...common import v1 as __common_v1__


@dataclass(eq=False, repr=False)
class PublicKey(betterproto.Message):
    """PublicKey contains an encoded public key"""

    raw_bytes: bytes = betterproto.bytes_field(1)
    """DER-encoded public key"""


@dataclass(eq=False, repr=False)
class Verifier(betterproto.Message):
    """
    Either a public key or a X.509 cerificiate with an embedded public key
    """

    public_key: Optional["PublicKey"] = betterproto.message_field(
        1, optional=True, group="verifier"
    )
    """
    DER-encoded public key. Encoding method is specified by the key_details attribute
    """

    x509_certificate: Optional["__common_v1__.X509Certificate"] = (
        betterproto.message_field(2, optional=True, group="verifier")
    )
    """DER-encoded certificate"""

    key_details: "__common_v1__.PublicKeyDetails" = betterproto.enum_field(3)
    """Key encoding and signature algorithm to use for this key"""

    @model_validator(mode="after")
    def check_oneof(cls, values):
        return cls._validate_field_groups(values)


@dataclass(eq=False, repr=False)
class Signature(betterproto.Message):
    """A signature and an associated verifier"""

    content: bytes = betterproto.bytes_field(1)
    verifier: "Verifier" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class DsseRequestV002(betterproto.Message):
    """A request to add a DSSE v0.0.2 entry to the log"""

    envelope: "____io_intoto__.Envelope" = betterproto.message_field(1)
    """A DSSE envelope"""

    verifiers: List["Verifier"] = betterproto.message_field(2)
    """
    All necessary verification material to verify all signatures embedded in the envelope
    """


@dataclass(eq=False, repr=False)
class DsseLogEntryV002(betterproto.Message):
    payload_hash: "__common_v1__.HashOutput" = betterproto.message_field(1)
    """The hash of the DSSE payload"""

    signatures: List["Signature"] = betterproto.message_field(2)
    """
    Signatures and their associated verification material used to verify the payload
    """


@dataclass(eq=False, repr=False)
class HashedRekordRequestV002(betterproto.Message):
    """A request to add a hashedrekord v0.0.2 to the log"""

    digest: bytes = betterproto.bytes_field(1)
    """The hashed data"""

    signature: "Signature" = betterproto.message_field(2)
    """
    A single signature over the hashed data with the verifier needed to validate it
    """


@dataclass(eq=False, repr=False)
class HashedRekordLogEntryV002(betterproto.Message):
    data: "__common_v1__.HashOutput" = betterproto.message_field(1)
    """The hashed data"""

    signature: "Signature" = betterproto.message_field(2)
    """
    A single signature over the hashed data with the verifier needed to validate it
    """


@dataclass(eq=False, repr=False)
class Entry(betterproto.Message):
    """
    Entry is the message that is canonicalized and uploaded to the log.
     This format is meant to be compliant with Rekor v1 entries in that
     the `apiVersion` and `kind` can be parsed before parsing the spec.
     Clients are expected to understand and handle the differences in the
     contents of `spec` between Rekor v1 (a polymorphic OpenAPI defintion)
     and Rekor v2 (a typed proto defintion).
    """

    kind: str = betterproto.string_field(1)
    api_version: str = betterproto.string_field(2)
    spec: "Spec" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Spec(betterproto.Message):
    """Spec contains one of the Rekor entry types."""

    hashed_rekord_v002: Optional["HashedRekordLogEntryV002"] = (
        betterproto.message_field(1, optional=True, group="spec")
    )
    dsse_v002: Optional["DsseLogEntryV002"] = betterproto.message_field(
        2, optional=True, group="spec"
    )

    @model_validator(mode="after")
    def check_oneof(cls, values):
        return cls._validate_field_groups(values)


@dataclass(eq=False, repr=False)
class CreateEntryRequest(betterproto.Message):
    """Create a new HashedRekord or DSSE"""

    hashed_rekord_request_v002: Optional["HashedRekordRequestV002"] = (
        betterproto.message_field(1, optional=True, group="spec")
    )
    dsse_request_v002: Optional["DsseRequestV002"] = betterproto.message_field(
        2, optional=True, group="spec"
    )

    @model_validator(mode="after")
    def check_oneof(cls, values):
        return cls._validate_field_groups(values)


rebuild_dataclass(Verifier)  # type: ignore
rebuild_dataclass(Signature)  # type: ignore
rebuild_dataclass(DsseRequestV002)  # type: ignore
rebuild_dataclass(DsseLogEntryV002)  # type: ignore
rebuild_dataclass(HashedRekordRequestV002)  # type: ignore
rebuild_dataclass(HashedRekordLogEntryV002)  # type: ignore
rebuild_dataclass(Entry)  # type: ignore
rebuild_dataclass(Spec)  # type: ignore
rebuild_dataclass(CreateEntryRequest)  # type: ignore
