/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.htm.core;

import edu.jhu.htm.core.HTMfunc;

public class Vector3d {
    double x_;
    double y_;
    double z_;
    double ra_;
    double dec_;
    boolean okRaDec_;

    public Vector3d() {
        this.x_ = 1.0;
        this.y_ = 0.0;
        this.z_ = 0.0;
        this.ra_ = 0.0;
        this.dec_ = 0.0;
        this.okRaDec_ = true;
    }

    public Vector3d(double d, double d2, double d3) {
        this.x_ = d;
        this.y_ = d2;
        this.z_ = d3;
        this.ra_ = 0.0;
        this.dec_ = 0.0;
        this.okRaDec_ = false;
    }

    public Vector3d(double d, double d2) {
        this.ra_ = d;
        this.dec_ = d2;
        this.okRaDec_ = true;
        this.updateXYZ();
    }

    public Vector3d(Vector3d vector3d) {
        this.x_ = vector3d.x_;
        this.y_ = vector3d.y_;
        this.z_ = vector3d.z_;
        this.ra_ = vector3d.ra_;
        this.dec_ = vector3d.dec_;
        this.okRaDec_ = vector3d.okRaDec_;
    }

    public void set(double d, double d2, double d3) {
        this.x_ = d;
        this.y_ = d2;
        this.z_ = d3;
        this.normalize();
        this.updateRaDec();
    }

    public void set(double d, double d2) {
        this.ra_ = d;
        this.dec_ = d2;
        this.okRaDec_ = true;
        this.updateXYZ();
    }

    public double[] get() {
        double[] dArray = new double[]{this.x_, this.y_, this.z_};
        return dArray;
    }

    public double length() {
        double d = this.x_ * this.x_ + this.y_ * this.y_ + this.z_ * this.z_;
        return Math.sqrt(d);
    }

    public double x() {
        return this.x_;
    }

    public double y() {
        return this.y_;
    }

    public double z() {
        return this.z_;
    }

    public void normalize() {
        double d = this.x_ * this.x_ + this.y_ * this.y_ + this.z_ * this.z_;
        d = Math.sqrt(d);
        this.x_ /= d;
        this.y_ /= d;
        this.z_ /= d;
    }

    public String toString() {
        return "" + this.x_ + " " + this.y_ + " " + this.z_;
    }

    public Vector3d cross(Vector3d vector3d) {
        return new Vector3d(this.y_ * vector3d.z_ - vector3d.y_ * this.z_, this.z_ * vector3d.x_ - vector3d.z_ * this.x_, this.x_ * vector3d.y_ - vector3d.x_ * this.y_);
    }

    public boolean equal(Vector3d vector3d) {
        return this.x_ == vector3d.x_ && this.y_ == vector3d.y_ && this.z_ == vector3d.z_;
    }

    public Vector3d mul(double d) {
        return new Vector3d(d * this.x_, d * this.y_, d * this.z_);
    }

    public double mul(Vector3d vector3d) {
        return this.x_ * vector3d.x_ + this.y_ * vector3d.y_ + this.z_ * vector3d.z_;
    }

    public Vector3d add(Vector3d vector3d) {
        return new Vector3d(this.x_ + vector3d.x_, this.y_ + vector3d.y_, this.z_ + vector3d.z_);
    }

    public Vector3d sub(Vector3d vector3d) {
        return new Vector3d(this.x_ - vector3d.x_, this.y_ - vector3d.y_, this.z_ - vector3d.z_);
    }

    public double dec() {
        if (!this.okRaDec_) {
            this.normalize();
            this.updateRaDec();
        }
        return this.dec_;
    }

    public double ra() {
        if (!this.okRaDec_) {
            this.normalize();
            this.updateRaDec();
        }
        return this.ra_;
    }

    protected void updateXYZ() {
        double d = Math.cos(this.dec_ * HTMfunc.Pr);
        this.x_ = Math.cos(this.ra_ * HTMfunc.Pr) * d;
        this.y_ = Math.sin(this.ra_ * HTMfunc.Pr) * d;
        this.z_ = Math.sin(this.dec_ * HTMfunc.Pr);
    }

    protected void updateRaDec() {
        this.dec_ = Math.asin(this.z_) / HTMfunc.Pr;
        double d = Math.cos(this.dec_ * HTMfunc.Pr);
        this.ra_ = d > HTMfunc.gEpsilon || d < -HTMfunc.gEpsilon ? (this.y_ > HTMfunc.gEpsilon || this.y_ < -HTMfunc.gEpsilon ? (this.y_ < 0.0 ? 360.0 - Math.acos(this.x_ / d) / HTMfunc.Pr : Math.acos(this.x_ / d) / HTMfunc.Pr) : (this.x_ < 0.0 ? 180.0 : 0.0)) : 0.0;
        this.okRaDec_ = true;
    }
}

