/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/resource.h>

int main(int argc, char *argv[])
{
    int i;
    int nfiles;
    int *fds;
    char *dir;
    struct stat statbuf;
    char name[16];
    struct rlimit rlim;

    if (argc != 3) {
        fprintf(stderr, "Usage: opentest <directory> <num_files>\n");
        exit(1);
    }

    dir = argv[1];

    nfiles = atoi(argv[2]);
    if ((nfiles <= 0) || (nfiles > 65536)) {
        fprintf(stderr, "num_files must be between 1 and 65536\n");
        exit(1);
    }

    if (stat(dir, &statbuf)) {
        fprintf(stderr, "Cannot stat %s\n", dir);
        exit(1);
    }

    if (! S_ISDIR(statbuf.st_mode)) {
        fprintf(stderr, "%s is not a directory!\n", dir);
        exit(1);
    }

    if (access(dir, R_OK | W_OK)) {
        fprintf(stderr, "No access to %s\n", dir);
        exit(1);
    }

    fds = malloc(nfiles * sizeof(int));
    if (fds == 0) {
        fprintf(stderr, "Unable to malloc array of %d fds\n", nfiles);
        exit(1);
    }

    if (chdir(dir)) {
        fprintf(stderr, "Cannot chdir to %s\n", dir);
        exit(1);
    }

    rlim.rlim_cur = nfiles + 10;
    rlim.rlim_max = nfiles + 10;
    if (setrlimit(RLIMIT_NOFILE, &rlim)) {
        fprintf(stderr, "Unable to raise RLIMIT_NOFILE to %ld\n", rlim.rlim_cur);
        exit(1);
    }

    for (i = 0; i < nfiles; i++) {
        snprintf(name, sizeof(name), "%d", i);
        fds[i] = open(name, O_WRONLY | O_CREAT, 0666);
        if (fds[i] < 0) {
            fprintf(stderr, "Unable to open %d fd\n", i);
            exit(1);
        }
    }

    /* Rely upon exit to cleanup! */
    exit(0);
}


